//Generate the level, and then choose remixes that go well with it.
//Does some very basic markov chaining to ensure interesting answers that can react to what you've selected
Remix.reset();

//Generic setup: define some remixes that should never occur at the same time
Remix.preventclash(['Lady Luck', 'Rat King']); //Upgraded equipment + super enemies don't work together
Remix.preventclash(['Snowman', 'Baby Squid', 'Fireman']); //More than one status effect dealer is messy
Remix.preventclash(['Singer', 'Bounty Hunter']); //Avoid more than one dice roll rule change for the player
Remix.preventclash(['Warlock', 'Banshee', 'Pirate']); //Don't have both Warlock and a remix that changes to PU rules
Remix.preventclash(['Vacuum', 'Drake']); //These both increase enemy health
//Remix.preventclash(['Space Marine']); //...or for the enemy

var enemylist = getenemylistindungeon();
var player = getplayername();

//Some remixes are very game defining, and it's better if they only come up very occasionally
var veryrare = ['Sneezy', 'Wisp', 'Sticky Hands'];
if(player != 'Robot') veryrare.push('Paper Knight'); //Robot shouldn't get Paper Knight
if(player != 'Robot') veryrare.push('Skeleton'); //Robot shouldn't get Skeleton
if(player != 'Witch') veryrare.push('Ned'); //Witch shouldn't get Ned, Val or Yolanda
if(player != 'Witch') veryrare.push('Yolanda'); //Witch shouldn't get Ned, Val or Yolanda
if(player != 'Witch') veryrare.push('Val'); //Witch shouldn't get Ned, Val or Yolanda

var poisonlist = ['Haunted Jar', 'Slime'];
var curselist = ['Dire Wolf', 'Banshee'];
var shocklist = ['Handyman'];
var firelist = ['Buster'];
poisonlist = shuffle(poisonlist);
curselist = shuffle(curselist);
shocklist = shuffle(shocklist);
firelist = shuffle(firelist);
var veryrareused = false;

var standardlist = ['Snowman', 'Baby Squid', 'Rat King', 'Warlock', 'Hothead', 'Fireman', 'Vacuum'];
if(player != 'Robot') standardlist.push('Singer'); //Robot shouldn't get Singer
//if(enemylist.indexOf('Handyman') > -1 || enemylist.indexOf('Beatrice') > -1){
//  standardlist.push(shocklist.pop());
//}

if(enemylist.indexOf('Fireman') > -1 || enemylist.indexOf('Buster') > -1){
  standardlist.push(firelist.pop());
}

var secondremixlist = [];

var earlytwists = ['Wolf Puppy', 'Mimic', 'Cactus', 'Rose', 'Pirate'];
if(player == 'Thief') earlytwists.push('The Thief'); //Finders Keepers rules
if(player == 'Inventor') earlytwists.push('The Inventor'); //PU Scrap rules
//if(player == 'Robot') earlytwists.push('The Robot'); //You Choose You Lose rules
//if(player == 'Witch') earlytwists.push('The Witch'); //Expect the unexpected rules
if(chance(75)){
  veryrareused = true;
  veryrare = shuffle(veryrare);
  earlytwists.push(veryrare.pop());
}


var hardlist = ['Loud Bird', 'Skeleton', 'Sorceress', 'Bully', 'Bounty Hunter', 'Cowboy', 'Kraken'];
if(player == 'Robot'){
  standardlist.push('Wisp'); //Robot shouldn't get Skeleton, but let's make them *more* likely to get Wisp
}else{
  standardlist.push('Skeleton');
}  
var midtwists = ['Scathach', 'Alchemist']; 
//Frog needs to exclude enemy equipment before it can be included, also a better plan for inventor limits
if(!veryrareused){
  veryrare = shuffle(veryrare);
  midtwists.push(veryrare.pop());
}

var cursecount = 0;
if(enemylist.indexOf('Banshee') > -1) cursecount++;
if(enemylist.indexOf('Dire Wolf') > -1) cursecount++;
if(enemylist.indexOf('Kraken') > -1) cursecount++;
if(enemylist.indexOf('Scathach') > -1) cursecount++;
if(enemylist.indexOf('Skeleton') > -1) cursecount++;
if(cursecount >= 3){
  hardlist.push(curselist.pop());
}

var poisoncount = 0;
if(enemylist.indexOf('Haunted Jar') > -1) poisoncount++;
if(enemylist.indexOf('Rat King') > -1) poisoncount++;
if(enemylist.indexOf('Drain Monster') > -1) poisoncount++;
if(enemylist.indexOf('Dire Wolf') > -1) poisoncount++;
if(cursecount >= 2){
  hardlist.push(poisonlist.pop());
}

var veryhardlist = ['Cornelius', 'Drake', 'Madison'];
if(enemylist.indexOf('Beatrice') > -1) veryhardlist.push('Handyman');

//Really simple first draft, shuffle all the lists, assign them randomly
earlytwists = shuffle(earlytwists);
standardlist.push(earlytwists.pop());
standardlist = shuffle(standardlist);

midtwists = shuffle(midtwists);
hardlist.push(midtwists.pop());
hardlist = shuffle(hardlist);

veryhardlist = shuffle(veryhardlist);

Remix.offer(2, '', [standardlist.pop(), standardlist.pop(), earlytwists.pop()]);

//Add some stuff we don't want to appear in the first remix, e.g. curse and poison related things
for(r in standardlist){
  secondremixlist.push(r);
}
if(chance(25)){
  secondremixlist.push('Rotten Apple'); //This one is brutal, keep it rare!
}
if(secondremixlist.indexOf('Rat King') > -1) secondremixlist.remove('Rat King'); //Rat King needs to appear as the first remix
secondremixlist = shuffle(secondremixlist);

Remix.offer(3, '', [secondremixlist.pop(), secondremixlist.pop(), midtwists.pop()]);
Remix.offer(4, '', [hardlist.pop(), hardlist.pop(), hardlist.pop()]);
Remix.offer(5, '', [veryhardlist.pop(), hardlist.pop(), veryhardlist.pop()]);